package gov.va.med.mhv.usermgmt.util;
import java.sql.Timestamp;
import java.util.Date;

import org.tigris.atlas.service.VoidServiceResponse;

import gov.va.med.mhv.usermgmt.enumeration.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.service.delegate.ActivityAuditServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.Activity;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;

public class Auditor {

		private static void auditIPAEvent(InPersonAuthentication ipa, Activity activity, String performerType){
			activity.setActionType(ActivityTypeEnumeration.IN_PERSON_AUTHENTICATION);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(performerType));
			if(ipa.getAuthenticatingFacility() != null){
				activity.setDetailValue(ipa.getAuthenticatingFacility().getName());
			}
			activity.setSubjectId(ipa.getPatient().getUserProfile().getId());
		}

		/**
		 * Audit authenication of a user, the audit call is in InPersonAuthenticationImpl in the method finalizeAuthentication
		 * @param ipa
		 * @param performerType
		 */
		public static void auditIPAAuthenticatedEvent(InPersonAuthentication ipa, String performerType){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.AUTHENTICATED));
			//activity.setPerformerId(performerId);
			auditIPAEvent(ipa, activity, performerType);

			if(ipa.getAllMessages().hasErrorMessages()){
				activity.setStatus(Boolean.FALSE);
			}
			else{
				activity.setStatus(Boolean.TRUE);
			}
			delegate.audit(activity);
		}

		/**
		 * Audit Unauthenication of a user, the audit call is in
         * InPersonAuthenticationImpl in the method finalizeUnAuthentication
		 * @param ipa
		 * @param performerType
		 */
		public static VoidServiceResponse auditIPAUnauthenticatedEvent(
            InPersonAuthentication ipa, String performerType)
        {
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.
                createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(
                ActivityActionTypeEnumeration.AUTHENTICATION_REVOKED));
			auditIPAEvent(ipa, activity,performerType);

			if(ipa.getAllMessages().hasErrorMessages()){
				activity.setStatus(Boolean.FALSE);
			}
			else{
				activity.setStatus(Boolean.TRUE);
			}
			return delegate.audit(activity);
		}


		/**
		 * Audit deferment authentication of a user, the audit call is in InPersonAuthenticationImpl in the method deferAuthentication
		 * @param ipa
		 * @param performerType
		 */
		public static void auditIPAInProcessEvent(InPersonAuthentication ipa, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.IN_PROCESS));
			auditIPAEvent(ipa, activity, actor);

			if(ipa.getAllMessages().hasErrorMessages()){
				activity.setStatus(Boolean.FALSE);
			}
			else{
				activity.setStatus(Boolean.TRUE);
			}
			delegate.audit(activity);
		}

		/**
		 * Audits Login of Users.  The audit call is in LoginPageFlowController in method logout
		 * @param subjectId Id of subject
		 */
		public static void auditLoginEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.LOGIN));
			activity.setActionType(ActivityTypeEnumeration.LOGIN_LOGOUT);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}

		/**
		 * Audits Login of DSLogon Users.  The audit call is in LoginPageFlowController in method logout
		 * @param subjectId Id of subject
		 */
		public static void auditEBenefitsLoginEvent(Long subjectId, String actor, Boolean successful, String deepLink, String activityDetailValue){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.LOGIN));
			if(null != deepLink){
				activity.setActionType(ActivityTypeEnumeration.DSLOGON);
				if(deepLink.equalsIgnoreCase("download_my_data"))
					activity.setDetailValue("From eBenefits to MHV Download My Data (Blue Button)");
				else if(deepLink.equalsIgnoreCase("prescription_refill"))
					activity.setDetailValue("From eBenefits to MHV Prescription Refill");
				else if(deepLink.equalsIgnoreCase("appointments"))
					activity.setDetailValue("From eBenefits to MHV VA Appts");
				else if(deepLink.equalsIgnoreCase("secure_messaging"))
					activity.setDetailValue("From eBenefits to MHV Secure Messaging");
			}else{
				activity.setActionType(ActivityTypeEnumeration.LOGIN_LOGOUT);
				//activity.setDetailValue("eBenefits");
				activity.setDetailValue(activityDetailValue);
			}
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}

		/**
		 * Audits Logouts of Users.  The audit call is in LogoutPageFlowController in method logout
		 * @param subjectId Id of subject
		 */
		public static void auditLogoutEvent(Long subjectId, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.LOGOUT));
			activity.setActionType(ActivityTypeEnumeration.LOGIN_LOGOUT);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}

		/**
		 * Audits Logouts of DSLogon Users.  The audit call is in LogoutPageFlowController in method logout
		 * @param subjectId Id of subject
		 */
		public static void auditDSLogonLogoutEvent(Long subjectId, String actor, String activityDetailValue){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.LOGOUT));
			activity.setActionType(ActivityTypeEnumeration.LOGIN_LOGOUT);
			//activity.setDetailValue("eBenefits");
			activity.setDetailValue(activityDetailValue);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}

		/**
		 * Audits Registrations of new Users.  The audit call is in UserRegistrationServiceImpl in method registerUser
		 * @param subjectId Id of subject
		 */
		public static VoidServiceResponse auditRegistrationEvent(Long subjectId, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.ACCOUNT_CREATED));
			activity.setActionType(ActivityTypeEnumeration.REGISTRATION);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			return delegate.audit(activity);
		}

		/**
		 * Audits updates to the User profile.  The audit call is in UserProfileServiceImpl in method doUserProfileSave
		 * @param subjectId Id of subject
		 */
		public static void auditUpdateProfileEvent(Long subjectId, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.UPDATE));
			activity.setActionType(ActivityTypeEnumeration.PROFILES);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}

		/**
		 * Audits Upgrade of Users Account.
		 * @param subjectId Id of subject
		 */
		public static void auditUpgradeEvent(Long subjectId, String actor, ActivityTypeEnumeration actionType, String activityDetailValue){
			auditUpgradeEvent(subjectId, actor, actionType.getName(), activityDetailValue);
		}

		public static void auditUpgradeEvent(Long subjectId, String actor, String actionType, String activityDetailValue){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.ACCOUNT_UPGRADE_REQUESTED));
			//activity.setActionType(ActivityTypeEnumeration.getEnum(ActivityTypeEnumeration.DSLOGON));
			activity.setActionType(actionType);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			//activity.setDetailValue("eBenefits");
			activity.setDetailValue(activityDetailValue);
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}
		
		/**
		 * Audits Upgrade of Users Account.
		 * @param subjectId Id of subject
		 */
		public static void auditDSLogonMappingEvent(Long subjectId, String actor, ActivityTypeEnumeration actionType, String activityDetailValue){
			auditDSLogonMappingEvent(subjectId, actor, actionType.getName(), activityDetailValue);
		}

		/**
		 * Audits Upgrade of Users Account.
		 * @param subjectId Id of subject
		 */
		public static void auditDSLogonMappingEvent(Long subjectId, String actor, String actionType, String activityDetailValue){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.ACCOUNT_CONNECTED));
			//activity.setActionType(ActivityTypeEnumeration.getEnum(ActivityTypeEnumeration.DSLOGON));
			activity.setActionType(actionType);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			//activity.setDetailValue("eBenefits");
			activity.setDetailValue(activityDetailValue);
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}

		/**
		 * Audits updates to the User profile.  The audit call is in UserProfileServiceImpl in method doUserProfileSave
		 * @param subjectId Id of subject
		 */
		public static void auditRequestDSLogonAccountEvent(Long subjectId, String actor, Boolean success, int detailCode){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.ACCOUNT_REQUESTED)); //Make it ACCOUNT_REQUESTED - but it will mix up with the MHV account activity types
			activity.setActionType(ActivityTypeEnumeration.DSLOGON);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(success);
			switch (detailCode)
			{
				case 0:
				case 7: {activity.setDetailValue("DSLogon account request processed successfully");}

				case 5:
				case 8:
				case 27: {activity.setDetailValue("Records could not be matched");}

				case 9:
				case 11:
				case 24:
				case 28:
				case 35:
				case 999:{activity.setDetailValue("A system error has occurred");}

				case 29:
				case 30: {activity.setDetailValue("DSLogon account already exists");}

				default:{activity.setDetailValue("Unrecognized error");}
			}

			delegate.audit(activity);
		}


		/**
		 * Audits updates to the User profile.  The audit call is in ChangePasswordController java class
		 * @param subjectId Id of subject
		 */
		public static void auditChangePasswordEvent(Long subjectId, String actor, Boolean success){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.PASSWORD_CHANGED));
			activity.setActionType(ActivityTypeEnumeration.PASSWORD);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(success);
			delegate.audit(activity);
		}

		/**
		 * Audits updates to the User profile.  The audit call is in UserProfileServiceImpl in method doUserProfileSave
		 * @param subjectId Id of subject
		 */
		public static void auditResetPasswordEvent(Long subjectId, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.RESET));
			activity.setActionType(ActivityTypeEnumeration.PASSWORD);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}

		/**
		 * Audits updates to the User profile.  The audit call is in UserProfileServiceImpl in method doUserProfileSave
		 * @param subjectId Id of subject
		 */
		public static void auditForgotPasswordEvent(Long subjectId, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.RECOVERED));
			activity.setActionType(ActivityTypeEnumeration.PASSWORD);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}


		/**
		 * Audits updates to the User profile.  The audit call is in UserProfileServiceImpl in method doUserProfileSave
		 * @param subjectId Id of subject
		 */
		public static void auditForgotUserIdEvent(Long subjectId, String actor, boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.RECOVERED));
			activity.setActionType(ActivityTypeEnumeration.USER_ID);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}

		/**
		 * Audits updates to the User profile.  The audit call is in UserProfileServiceImpl in method doUserProfileSave
		 * @param subjectId Id of subject
		 */
		public static void auditAcceptTermsEvent(Long subjectId, boolean accept, String actor){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			if(accept)
				activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.ACCEPT));
			else
				activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.DECLINE));
			activity.setActionType(ActivityTypeEnumeration.TERMS_AND_CONDITIONS);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(Boolean.TRUE);
			delegate.audit(activity);
		}
		/*
		 * Audit the Share Data Request Events.
		 */
		public static void auditShareCCDRequestEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityActionDetail){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType));
			activity.setDetailValue(activityActionDetail);
			activity.setActionType(ActivityTypeEnumeration.SEND_HEALTH_SUMMARY);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}
		/*
		 * Audit the Share Data Request Events.
		 */
		public static void auditAcceptShareCCDDisclaimerRequestEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityActionDetail){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType));
			activity.setDetailValue(activityActionDetail);
			activity.setActionType(ActivityTypeEnumeration.SEND_HEALTH_SUMMARY);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}
		/*
		 * Audit the Share Data Request Events.
		 */
		public static void auditShareDataWithHRAEvent(Long subjectId, String actor, boolean accept, Boolean successful, String activityActionType){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			if(accept)
				activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.CONTINUE));
			else
				activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.CANCEL));
			activity.setDetailValue(activityActionType);
			activity.setActionType(ActivityTypeEnumeration.SHARE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}
		/*
		 * Audit the Download Data Request Events.
		 */
		public static void auditDownloadDataRequestEvent(Long subjectId, String actor, Boolean successful, String activityActionType){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType));
			activity.setActionType(ActivityTypeEnumeration.DOWNLOAD);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}

		/**
		 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
		 */
		public static void auditMviAuthenticateRequestEvent(Long subjectId, String actor, Boolean successful, String facilityName) {
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.AUTHENTICATION_REQUEST));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(facilityName);
			delegate.audit(activity);
		}

		/**
		 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
		 */
		public static void auditMviAuthenticateEvent(Long subjectId, String actor, Boolean successful, String facilityName){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.UPGRADE_TO_PREMIUM));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(facilityName);
			delegate.audit(activity);
		}

		/**
		 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
		 */
		public static void auditMviUnauthenticateRequestEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.UNAUTHENTICATION_REQUEST));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(null);
			delegate.audit(activity);
		}

		/**
		 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
		 */
		public static void auditMviUnauthenticateEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.PREMIUM_ACCOUNT_REVOKED));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(null);
			delegate.audit(activity);
		}

		/**
		 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
		 */
		public static void auditMviCorrelateEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");
			delegate.audit(activity);
		}

		/**
		 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
		 */
		public static void auditMviIpaMatchEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");
			delegate.audit(activity);
		}

		/**
		 * Audits MVI Match & Correlation Event
		 */
		public static void auditMviEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityType){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType));
			//activity.setActionType(ActivityTypeEnumeration.getEnum(ActivityTypeEnumeration.REGISTRATION));
			activity.setActionType(activityType);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");
			delegate.audit(activity);
		}

		public static void auditMviLoginEvent(Long subjectId, String actor, Boolean successful, String activityActionType){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType));
			activity.setActionType(ActivityTypeEnumeration.LOGIN_LOGOUT);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");
			delegate.audit(activity);
		}

		//Admin Portal_CodeCR1959 - React/Deact Impl
		public static void auditAccountDeactivateEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setActionType(ActivityActionTypeEnumeration.ACCOUNT_MANAGEMENT);
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityTypeEnumeration.DEACTIVATE));
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}

		//Admin Portal_CodeCR1959 - React/Deact Impl
		public static void auditAccountReactivateEvent(Long subjectId, String actor, Boolean successful){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setActionType(ActivityActionTypeEnumeration.ACCOUNT_MANAGEMENT);
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityTypeEnumeration.REACTIVATE));
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			delegate.audit(activity);
		}

		/**
		 * Audits for VBH Handbook
		 */

		public static void auditVBHHandbookEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityType){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(activityActionType));
			//activity.setActionType(ActivityTypeEnumeration.getEnum(ActivityTypeEnumeration.REGISTRATION));
			activity.setActionType(activityType);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(actor));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");
			delegate.audit(activity);
		}
		
		public static void auditAccountDeactivateEauthHashEvent(Long subjectId){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.ACCOUNT_DISCONNECTED));
			activity.setActionType(ActivityTypeEnumeration.DSLOGON_CAC_USAA_ORC);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(ActivityActorTypeEnumeration.SELF));
			activity.setSubjectId(subjectId);
			activity.setStatus(true);
			activity.setDetailValue("Deactivation");
			delegate.audit(activity);
		}
		
		public static void auditAccountUpgradeEvent(Long subjectId, Boolean successful, String performer){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(performer));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");
			delegate.audit(activity);
		}

		//JAZZ#32762 US02 The MHV System shall create an AAL entry for the onlineupgrade process.   
		public static void auditOnlineAuthenticationEvent(Long subjectId, Boolean successful, String activityName, String actionName, String detail){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(actionName));
			activity.setActionType(activityName);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(ActivityActorTypeEnumeration.SELF));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(detail);
			delegate.audit(activity);
		}
		
		//JAZZ#32762 US02 The MHV System shall create an AAL entry for the onlineupgrade process.   
		public static void auditManualAuthenticationEvent(Long subjectId, Boolean successful, String actionName, String detail){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(actionName));
			activity.setActionType(ActivityTypeEnumeration.ACCOUNT_UPGRADE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(ActivityActorTypeEnumeration.SELF));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(detail);
			delegate.audit(activity);
		}
		
		//JAZZ#32762 US02 The MHV System shall create an AAL entry for the onlineupgrade process.   
		public static void auditDownloadViewPrintERAREvent(Long subjectId, Boolean successful, String actionName, String detail){
			ActivityAuditServiceDelegate delegate = ServiceDelegateFactory.createActivityAuditServiceDelegate();
			Activity activity = TransferObjectFactory.createActivity();
			activity.setAction(ActivityActionTypeEnumeration.getEnum(actionName));
			activity.setActionType(ActivityTypeEnumeration.ONLINE_FORM_AVAILABLE);
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(ActivityActorTypeEnumeration.getEnum(ActivityActorTypeEnumeration.SELF));
			activity.setSubjectId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(detail);
			delegate.audit(activity);
		}
}
